/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.storage.database.sql.building.Update;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import java.util.function.BooleanSupplier;

public class BanStatusTransaction
extends Transaction {
    private final UUID playerUUID;
    private final BooleanSupplier banStatus;

    public BanStatusTransaction(UUID playerUUID, BooleanSupplier banStatus) {
        this.playerUUID = playerUUID;
        this.banStatus = banStatus;
    }

    @Override
    protected void performOperations() {
        this.execute(this.updateBanStatus());
    }

    private Executable updateBanStatus() {
        String sql = Update.values("plan_user_info", "banned").where("uuid=?").toString();
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, BanStatusTransaction.this.banStatus.getAsBoolean());
                statement.setString(2, BanStatusTransaction.this.playerUUID.toString());
            }
        };
    }
}

