/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.gathering.domain.GeoInfo;
import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.net.InetAddress;
import java.util.UUID;
import java.util.function.UnaryOperator;

public class GeoInfoStoreTransaction
extends Transaction {
    private final UUID playerUUID;
    private String ip;
    private long time;
    private UnaryOperator<String> geolocationFunction;
    private GeoInfo geoInfo;

    public GeoInfoStoreTransaction(UUID playerUUID, String ip, long time, UnaryOperator<String> geolocationFunction) {
        this.playerUUID = playerUUID;
        this.ip = ip;
        this.time = time;
        this.geolocationFunction = geolocationFunction;
    }

    public GeoInfoStoreTransaction(UUID playerUUID, InetAddress ip, long time, UnaryOperator<String> geolocationFunction) {
        this.playerUUID = playerUUID;
        this.ip = ip.getHostAddress();
        this.time = time;
        this.geolocationFunction = geolocationFunction;
    }

    public GeoInfoStoreTransaction(UUID playerUUID, GeoInfo geoInfo) {
        this.playerUUID = playerUUID;
        this.geoInfo = geoInfo;
    }

    private GeoInfo createGeoInfo() {
        String country = (String)this.geolocationFunction.apply(this.ip);
        return new GeoInfo(country, this.time);
    }

    @Override
    protected void performOperations() {
        if (this.geoInfo == null) {
            this.geoInfo = this.createGeoInfo();
        }
        if (this.geoInfo.getGeolocation() == null) {
            return;
        }
        this.execute(DataStoreQueries.storeGeoInfo(this.playerUUID, this.geoInfo));
    }
}

