/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.util.UUID;
import java.util.function.BiPredicate;

public class NicknameStoreTransaction
extends ThrowawayTransaction {
    private final UUID playerUUID;
    private final Nickname nickname;
    private final BiPredicate<UUID, String> isNicknameCachedCheck;

    public NicknameStoreTransaction(UUID playerUUID, Nickname nickname, BiPredicate<UUID, String> isNicknameCachedCheck) {
        this.playerUUID = playerUUID;
        this.nickname = nickname;
        this.isNicknameCachedCheck = isNicknameCachedCheck;
    }

    @Override
    protected boolean shouldBeExecuted() {
        return !this.isNicknameCachedCheck.test(this.playerUUID, this.nickname.getName());
    }

    @Override
    protected void performOperations() {
        this.execute(DataStoreQueries.storePlayerNickname(this.playerUUID, this.nickname));
    }
}

