/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.storage.database.sql.building.Update;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class OperatorStatusTransaction
extends ThrowawayTransaction {
    private final UUID playerUUID;
    private final boolean operatorStatus;

    public OperatorStatusTransaction(UUID playerUUID, boolean operatorStatus) {
        this.playerUUID = playerUUID;
        this.operatorStatus = operatorStatus;
    }

    @Override
    protected void performOperations() {
        this.execute(this.updateOperatorStatus());
    }

    private Executable updateOperatorStatus() {
        String sql = Update.values("plan_user_info", "opped").where("uuid=?").toString();
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, OperatorStatusTransaction.this.operatorStatus);
                statement.setString(2, OperatorStatusTransaction.this.playerUUID.toString());
            }
        };
    }
}

