/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.gathering.domain.Ping;
import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import com.djrapitops.plan.utilities.Predicates;
import com.djrapitops.plan.utilities.analysis.Median;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.List;
import java.util.UUID;

public class PingStoreTransaction
extends Transaction {
    private final UUID playerUUID;
    private final UUID serverUUID;
    private final List<DateObj<Integer>> pingList;

    public PingStoreTransaction(UUID playerUUID, UUID serverUUID, List<DateObj<Integer>> pingList) {
        this.playerUUID = playerUUID;
        this.serverUUID = serverUUID;
        this.pingList = pingList;
    }

    @Override
    protected void performOperations() {
        Ping ping = this.calculateAggregatePing();
        this.execute(DataStoreQueries.storePing(this.playerUUID, this.serverUUID, ping));
    }

    private Ping calculateAggregatePing() {
        long lastDate = this.pingList.get(this.pingList.size() - 1).getDate();
        int minValue = this.getMinValue();
        int meanValue = this.getMeanValue();
        int maxValue = this.getMax();
        return new Ping(lastDate, this.serverUUID, minValue, maxValue, meanValue);
    }

    private int getMinValue() {
        return this.pingList.stream().mapToInt(DateObj::getValue).filter(Predicates::pingInRange).min().orElse(-1);
    }

    private int getMax() {
        return this.pingList.stream().mapToInt(DateObj::getValue).filter(Predicates::pingInRange).max().orElse(-1);
    }

    int getMeanValue() {
        List<Integer> values = Lists.map(this.pingList, DateObj::getValue);
        return (int)Median.forList(values).calculate();
    }
}

