/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.util.UUID;
import java.util.function.LongSupplier;

public class PlayerRegisterTransaction
extends Transaction {
    protected final UUID playerUUID;
    protected final LongSupplier registered;
    private final String playerName;

    public PlayerRegisterTransaction(UUID playerUUID, LongSupplier registered, String playerName) {
        this.playerUUID = playerUUID;
        this.registered = registered;
        this.playerName = playerName;
    }

    @Override
    protected boolean shouldBeExecuted() {
        return this.playerUUID != null && this.playerName != null;
    }

    @Override
    protected void performOperations() {
        if (!this.query(PlayerFetchQueries.isPlayerRegistered(this.playerUUID)).booleanValue()) {
            long registerDate = this.registered.getAsLong();
            this.insertUser(registerDate);
            SessionCache.getCachedSession(this.playerUUID).ifPresent(session -> session.setAsFirstSessionIfMatches(registerDate));
        }
        this.execute(DataStoreQueries.updatePlayerName(this.playerUUID, this.playerName));
        JSONCache.invalidateMatching(DataID.PLAYERS);
    }

    private void insertUser(long registerDate) {
        block2: {
            try {
                this.execute(DataStoreQueries.registerBaseUser(this.playerUUID, registerDate, this.playerName));
            }
            catch (DBOpException failed) {
                boolean alreadySaved = failed.getMessage().contains("Duplicate entry");
                if (alreadySaved) break block2;
                throw failed;
            }
        }
    }
}

