/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.queries.PlayerFetchQueries;
import com.djrapitops.plan.storage.database.transactions.events.PlayerRegisterTransaction;
import java.util.Optional;
import java.util.UUID;
import java.util.function.LongSupplier;

public class PlayerServerRegisterTransaction
extends PlayerRegisterTransaction {
    private final UUID serverUUID;

    public PlayerServerRegisterTransaction(UUID playerUUID, LongSupplier registered, String playerName, UUID serverUUID) {
        super(playerUUID, registered, playerName);
        this.serverUUID = serverUUID;
    }

    @Override
    protected void performOperations() {
        Optional<Long> foundRegisterDate;
        super.performOperations();
        long registerDate = this.registered.getAsLong();
        if (!this.query(PlayerFetchQueries.isPlayerRegisteredOnServer(this.playerUUID, this.serverUUID)).booleanValue()) {
            this.execute(DataStoreQueries.registerUserInfo(this.playerUUID, registerDate, this.serverUUID));
        }
        if ((foundRegisterDate = this.query(PlayerFetchQueries.fetchRegisterDate(this.playerUUID))).isPresent() && foundRegisterDate.get() > registerDate) {
            this.execute(DataStoreQueries.updateMainRegisterDate(this.playerUUID, registerDate));
        }
    }
}

