/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.events;

import com.djrapitops.plan.storage.database.queries.DataStoreQueries;
import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class WorldNameStoreTransaction
extends Transaction {
    private final UUID serverUUID;
    private final String worldName;

    public WorldNameStoreTransaction(UUID serverUUID, String worldName) {
        this.serverUUID = serverUUID;
        this.worldName = worldName;
    }

    @Override
    protected boolean shouldBeExecuted() {
        return this.doesWorldNameNotExist();
    }

    private boolean doesWorldNameNotExist() {
        String sql = "SELECT COUNT(1) as c FROM plan_worlds WHERE world_name=? AND server_uuid=?";
        return this.query(new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StringUtils.truncate(WorldNameStoreTransaction.this.worldName, 100));
                statement.setString(2, WorldNameStoreTransaction.this.serverUUID.toString());
            }
        }) == false;
    }

    @Override
    protected void performOperations() {
        this.execute(DataStoreQueries.insertWorldName(this.serverUUID, this.worldName));
    }
}

