/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.init;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.queries.schema.MySQLSchemaQueries;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import plan.org.apache.commons.text.TextStringBuilder;

public class CreateIndexTransaction
extends Transaction {
    @Override
    protected void performOperations() {
        this.createIndex("plan_users", "plan_users_uuid_index", "uuid");
        this.createIndex("plan_user_info", "plan_user_info_uuid_index", "uuid", "server_uuid");
        this.createIndex("plan_sessions", "plan_sessions_uuid_index", "uuid", "server_uuid");
        this.createIndex("plan_sessions", "plan_sessions_date_index", "session_start");
        this.createIndex("plan_world_times", "plan_world_times_uuid_index", "uuid", "server_uuid");
        this.createIndex("plan_kills", "plan_kills_uuid_index", "killer_uuid", "victim_uuid", "server_uuid");
        this.createIndex("plan_kills", "plan_kills_date_index", "date");
        this.createIndex("plan_ping", "plan_ping_uuid_index", "uuid", "server_uuid");
        this.createIndex("plan_ping", "plan_ping_date_index", "date");
        this.createIndex("plan_tps", "plan_tps_date_index", "date");
    }

    private void createIndex(String tableName, String indexName, String ... indexedColumns) {
        boolean indexExists;
        boolean isMySQL;
        if (indexedColumns.length == 0) {
            throw new IllegalArgumentException("Can not create index without columns");
        }
        boolean bl = isMySQL = this.dbType == DBType.MYSQL;
        if (isMySQL && (indexExists = this.query(MySQLSchemaQueries.doesIndexExist(indexName, tableName)).booleanValue())) {
            return;
        }
        TextStringBuilder sql = new TextStringBuilder("CREATE INDEX ");
        if (!isMySQL) {
            sql.append("IF NOT EXISTS ");
        }
        sql.append(indexName).append(" ON ").append(tableName);
        sql.append(" (");
        sql.appendWithSeparators(indexedColumns, ",");
        sql.append(')');
        this.execute(sql.toString());
    }
}

