/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.init;

import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;

public class RemoveDuplicateUserInfoTransaction
extends ThrowawayTransaction {
    private static final String STATEMENT_SELECT_DUPLICATE_IDS = "SELECT DISTINCT u2.id as id FROM plan_user_info u1 JOIN plan_user_info u2 on u1.uuid=u2.uuid AND u1.server_uuid=u2.server_uuid AND u1.id<u2.id";

    @Override
    protected void performOperations() {
        final Collection<Integer> duplicateIDs = this.getDuplicates();
        if (duplicateIDs.isEmpty()) {
            return;
        }
        this.execute(new ExecBatchStatement("DELETE FROM plan_user_info WHERE id=?"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Integer id : duplicateIDs) {
                    statement.setInt(1, id);
                    statement.addBatch();
                }
            }
        });
    }

    private Collection<Integer> getDuplicates() {
        return this.query(new QueryAllStatement<Collection<Integer>>(STATEMENT_SELECT_DUPLICATE_IDS){

            @Override
            public Collection<Integer> processResults(ResultSet set) throws SQLException {
                HashSet<Integer> duplicateIDs = new HashSet<Integer>();
                while (set.next()) {
                    duplicateIDs.add(set.getInt("id"));
                }
                return duplicateIDs;
            }
        });
    }
}

