/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.init;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;

public class RemoveOldExtensionsTransaction
extends ThrowawayTransaction {
    private final long deleteOlder;
    private final UUID serverUUID;

    public RemoveOldExtensionsTransaction(long deleteAfterMs, UUID serverUUID) {
        this.deleteOlder = System.currentTimeMillis() - deleteAfterMs;
        this.serverUUID = serverUUID;
    }

    @Override
    protected void performOperations() {
        for (Integer providerID : this.query(this.inactiveProviderIDsQuery())) {
            this.removeValues(providerID);
        }
        for (Integer providerID : this.query(this.inactiveTableProviderIDsQuery())) {
            this.removeTableValues(providerID);
        }
        this.removeProviders();
    }

    private void removeValues(final int providerID) {
        for (String table : new String[]{"plan_extension_user_values", "plan_extension_server_values", "plan_extension_groups"}) {
            this.execute(new ExecStatement("DELETE FROM " + table + " WHERE " + "provider_id=?"){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setInt(1, providerID);
                }
            });
        }
    }

    private void removeTableValues(final Integer providerID) {
        for (String table : new String[]{"plan_extension_user_table_values", "plan_extension_server_table_values"}) {
            this.execute(new ExecStatement("DELETE FROM " + table + " WHERE " + "table_id=?"){

                @Override
                public void prepare(PreparedStatement statement) throws SQLException {
                    statement.setInt(1, providerID);
                }
            });
        }
    }

    private void removeProviders() {
        this.execute(new ExecStatement("DELETE FROM plan_extension_providers WHERE plugin_id IN (SELECT id FROM plan_extension_plugins WHERE last_updated<? AND server_uuid=?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, RemoveOldExtensionsTransaction.this.deleteOlder);
                statement.setString(2, RemoveOldExtensionsTransaction.this.serverUUID.toString());
            }
        });
        this.execute(new ExecStatement("DELETE FROM plan_extension_tables WHERE plugin_id IN (SELECT id FROM plan_extension_plugins WHERE last_updated<? AND server_uuid=?)"){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, RemoveOldExtensionsTransaction.this.deleteOlder);
                statement.setString(2, RemoveOldExtensionsTransaction.this.serverUUID.toString());
            }
        });
    }

    private Query<Collection<Integer>> inactiveProviderIDsQuery() {
        String sql = "SELECT pr.id FROM plan_extension_providers pr JOIN plan_extension_plugins pl on pl.id=pr.plugin_id WHERE last_updated<? AND server_uuid=?";
        return new QueryStatement<Collection<Integer>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, RemoveOldExtensionsTransaction.this.deleteOlder);
                statement.setString(2, RemoveOldExtensionsTransaction.this.serverUUID.toString());
            }

            @Override
            public Collection<Integer> processResults(ResultSet set) throws SQLException {
                HashSet<Integer> providerIds = new HashSet<Integer>();
                while (set.next()) {
                    providerIds.add(set.getInt("id"));
                }
                return providerIds;
            }
        };
    }

    private Query<Collection<Integer>> inactiveTableProviderIDsQuery() {
        String sql = "SELECT pr.id FROM plan_extension_tables pr JOIN plan_extension_plugins pl on pl.id=pr.plugin_id WHERE last_updated<? AND server_uuid=?";
        return new QueryStatement<Collection<Integer>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, RemoveOldExtensionsTransaction.this.deleteOlder);
                statement.setString(2, RemoveOldExtensionsTransaction.this.serverUUID.toString());
            }

            @Override
            public Collection<Integer> processResults(ResultSet set) throws SQLException {
                HashSet<Integer> providerIds = new HashSet<Integer>();
                while (set.next()) {
                    providerIds.add(set.getInt("id"));
                }
                return providerIds;
            }
        };
    }
}

