/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.init;

import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

public class RemoveOldSampledDataTransaction
extends ThrowawayTransaction {
    private final UUID serverUUID;
    private final long deleteTPSOlderThanMs;
    private final long deletePingOlderThanMs;

    public RemoveOldSampledDataTransaction(UUID serverUUID, long deleteTPSOlderThanMs, long deletePingOlderThanMs) {
        this.serverUUID = serverUUID;
        this.deleteTPSOlderThanMs = deleteTPSOlderThanMs;
        this.deletePingOlderThanMs = deletePingOlderThanMs;
    }

    @Override
    protected void performOperations() {
        Optional<Integer> allTimePeak = this.query(TPSQueries.fetchAllTimePeakPlayerCount(this.serverUUID)).map(DateObj::getValue);
        this.execute(this.cleanTPSTable(allTimePeak.orElse(-1)));
        this.execute(this.cleanPingTable());
    }

    private Executable cleanTPSTable(final int allTimePlayerPeak) {
        String sql = "DELETE FROM plan_tps WHERE date<? AND players_online!=? AND server_id=(SELECT plan_servers.id FROM plan_servers WHERE plan_servers.uuid=? LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, System.currentTimeMillis() - RemoveOldSampledDataTransaction.this.deleteTPSOlderThanMs);
                statement.setInt(2, allTimePlayerPeak);
                statement.setString(3, RemoveOldSampledDataTransaction.this.serverUUID.toString());
            }
        };
    }

    private Executable cleanPingTable() {
        String sql = "DELETE FROM plan_ping WHERE (date<? AND server_uuid=?) OR min_ping<0";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, System.currentTimeMillis() - RemoveOldSampledDataTransaction.this.deletePingOlderThanMs);
                statement.setString(2, RemoveOldSampledDataTransaction.this.serverUUID.toString());
            }
        };
    }
}

