/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;

public class BadAFKThresholdValuePatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        return !this.containsSessionsWithFullAFK();
    }

    private boolean containsSessionsWithFullAFK() {
        String sql = "SELECT COUNT(1) as found FROM plan_sessions WHERE ABS(afk_time - (session_end-session_start)) < 5 AND afk_time!=0";
        return this.query(new HasMoreThanZeroQueryStatement(sql, "found"){

            @Override
            public void prepare(PreparedStatement statement) {
            }
        });
    }

    @Override
    protected void applyPatch() {
        String sql = "UPDATE plan_sessions SET afk_time=0 WHERE ABS(afk_time - (session_end-session_start)) < 5 AND afk_time!=0";
        this.execute(sql);
    }
}

