/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BadNukkitRegisterValuePatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        return this.hasNoWrongRegisterDates("plan_user_info", "registered") && this.hasNoWrongRegisterDates("plan_users", "registered");
    }

    public boolean hasNoWrongRegisterDates(String tableName, String registered) {
        String sql = "SELECT COUNT(*) as c FROM " + tableName + " WHERE " + registered + "<?";
        Boolean foundWrongRegisterDates = this.query(new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, System.currentTimeMillis() / 1000L);
            }
        });
        return foundWrongRegisterDates == false;
    }

    @Override
    protected void applyPatch() {
        this.multiplyInTable("plan_user_info", "registered");
        this.multiplyInTable("plan_users", "registered");
    }

    private void multiplyInTable(String tableName, String registered) {
        String sql = "UPDATE " + tableName + " SET " + registered + "=" + registered + "*1000" + " WHERE " + registered + "<?";
        this.execute(new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, System.currentTimeMillis() / 1000L);
            }
        });
    }
}

