/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.sql.tables.GeoInfoTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DeleteIPsPatch
extends Patch {
    private final String oldTableName;
    private final String tempTableName;

    public DeleteIPsPatch() {
        this.oldTableName = "plan_ips";
        this.tempTableName = "temp_ips";
    }

    @Override
    public boolean hasBeenApplied() {
        return !this.hasTable(this.oldTableName);
    }

    @Override
    protected void applyPatch() {
        if (this.hasTable("plan_geolocations") && this.hasLessDataInPlanIPs()) {
            this.dropTable(this.oldTableName);
            return;
        }
        this.tempOldTable();
        this.dropTable("plan_geolocations");
        this.execute(GeoInfoTable.createTableSQL(this.dbType));
        this.execute("INSERT INTO plan_geolocations (uuid,last_used,geolocation) SELECT DISTINCT uuid,last_used,geolocation FROM " + this.tempTableName);
        this.dropTable(this.tempTableName);
    }

    private boolean hasLessDataInPlanIPs() {
        Integer inIPs = this.query(new QueryAllStatement<Integer>("SELECT COUNT(1) as c FROM " + this.oldTableName){

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("c") : 0;
            }
        });
        Integer inGeoInfo = this.query(new QueryAllStatement<Integer>("SELECT COUNT(1) as c FROM plan_geolocations"){

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                return set.next() ? set.getInt("c") : 0;
            }
        });
        return inIPs <= inGeoInfo;
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.oldTableName, this.tempTableName);
        }
    }
}

