/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.queries.schema.H2SchemaQueries;
import com.djrapitops.plan.storage.database.queries.schema.MySQLSchemaQueries;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class ExtensionTableRowValueLengthPatch
extends Patch {
    private final String playerTable;
    private final String serverTable;

    public ExtensionTableRowValueLengthPatch() {
        this.playerTable = "plan_extension_user_table_values";
        this.serverTable = "plan_extension_server_table_values";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.dbType == DBType.SQLITE || this.columnVarcharLength(this.playerTable, "col_4_value") >= 250 && this.columnVarcharLength(this.serverTable, "col_5_value") >= 250;
    }

    private int columnVarcharLength(String table, String column) {
        if (this.dbType == DBType.MYSQL) {
            return this.query(MySQLSchemaQueries.columnVarcharLength(table, column));
        }
        return this.query(H2SchemaQueries.columnVarcharLength(table, column));
    }

    @Override
    protected void applyPatch() {
        this.increaseLength(this.playerTable, "col_1_value");
        this.increaseLength(this.playerTable, "col_2_value");
        this.increaseLength(this.playerTable, "col_3_value");
        this.increaseLength(this.playerTable, "col_4_value");
        this.increaseLength(this.serverTable, "col_1_value");
        this.increaseLength(this.serverTable, "col_2_value");
        this.increaseLength(this.serverTable, "col_3_value");
        this.increaseLength(this.serverTable, "col_4_value");
        this.increaseLength(this.serverTable, "col_5_value");
    }

    private void increaseLength(String table, String column) {
        this.execute("ALTER TABLE " + table + " MODIFY " + column + " " + Sql.varchar(250));
    }
}

