/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.sql.tables.GeoInfoTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class GeoInfoOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String oldTableName;

    public GeoInfoOptimizationPatch() {
        this.oldTableName = "plan_ips";
        this.tempTableName = "temp_ips";
    }

    @Override
    public boolean hasBeenApplied() {
        return !this.hasTable(this.oldTableName) || this.hasColumn(this.oldTableName, "id") && this.hasColumn(this.oldTableName, "uuid") && !this.hasColumn(this.oldTableName, "user_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        this.tempOldTable();
        this.execute(GeoInfoTable.createTableSQL(this.dbType));
        this.execute("INSERT INTO plan_geolocations (uuid,last_used,geolocation) SELECT DISTINCT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".user_id LIMIT 1), " + "last_used" + ',' + "geolocation" + " FROM " + this.tempTableName);
        this.dropTable(this.tempTableName);
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.oldTableName, this.tempTableName);
        }
    }
}

