/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.KillsTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class KillsOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public KillsOptimizationPatch() {
        this.tableName = "plan_kills";
        this.tempTableName = "temp_kills";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "victim_uuid") && this.hasColumn(this.tableName, "killer_uuid") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "killer_id") && !this.hasColumn(this.tableName, "victim_id") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            if (this.hasTable(this.tempTableName) && this.hasColumn(this.tempTableName, "victim_uuid")) {
                this.renameTable(this.tempTableName, this.tableName);
                return;
            }
            if (this.hasColumn(this.tableName, "victim_uuid")) {
                return;
            }
            this.tempOldTable();
            this.execute(KillsTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "victim_uuid" + ',' + "killer_uuid" + ',' + "server_uuid" + ',' + "date" + ',' + "weapon" + ',' + "session_id" + ") SELECT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".victim_id LIMIT 1), (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".killer_id LIMIT 1), (SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "date" + ',' + "weapon" + ',' + "session_id" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(KillsOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

