/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.schema.SessionIDServerIDRelationQuery;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public class KillsServerIDPatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        String tableName = "plan_kills";
        String columnName = "server_id";
        return this.hasColumn(tableName, "server_uuid") || this.hasColumn(tableName, columnName) && this.allValuesHaveValueZero(tableName, columnName);
    }

    @Override
    protected void applyPatch() {
        if (this.hasColumn("plan_kills", "server_uuid")) {
            return;
        }
        this.addColumn("plan_kills", "server_id integer NOT NULL DEFAULT 0");
        final Map<Integer, Integer> sessionIDServerIDRelation = this.query(new SessionIDServerIDRelationQuery());
        String sql = "UPDATE plan_kills SET server_id=? WHERE session_id=?";
        this.execute(new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : sessionIDServerIDRelation.entrySet()) {
                    Integer sessionID = (Integer)entry.getKey();
                    Integer serverID = (Integer)entry.getValue();
                    statement.setInt(1, serverID);
                    statement.setInt(2, sessionID);
                    statement.addBatch();
                }
            }
        });
    }
}

