/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class LinkUsersToPlayersSecurityTablePatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        String sql = "SELECT COUNT(1) as c FROM plan_security WHERE linked_to_uuid=''";
        return this.query(new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) {
            }
        }) == false;
    }

    @Override
    protected void applyPatch() {
        String querySQL = "SELECT uuid,username FROM plan_security LEFT JOIN plan_users on name=username WHERE linked_to_uuid=''";
        String sql = "UPDATE plan_security SET linked_to_uuid=? WHERE username=?";
        final Map<String, String> byUsername = this.query(new QueryAllStatement<Map<String, String>>(querySQL){

            @Override
            public Map<String, String> processResults(ResultSet set) throws SQLException {
                HashMap<String, String> byUsername = new HashMap<String, String>();
                while (set.next()) {
                    byUsername.put(set.getString("username"), set.getString("uuid"));
                }
                return byUsername;
            }
        });
        this.execute(new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry usernameUUIDPair : byUsername.entrySet()) {
                    Sql.setStringOrNull(statement, 1, (String)usernameUUIDPair.getValue());
                    statement.setString(2, (String)usernameUUIDPair.getKey());
                    statement.addBatch();
                }
            }
        });
    }
}

