/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class LitebansTableHeaderPatch
extends Patch {
    private Set<Integer> found;

    @Override
    public boolean hasBeenApplied() {
        String sql = "SELECT DISTINCT pr.id as id FROM plan_extension_server_table_values v JOIN plan_extension_tables pr on pr.id=v.table_id JOIN plan_extension_plugins p on p.id=pr.plugin_id WHERE p.name=? AND (pr.name=? OR pr.name=? OR pr.name=? OR pr.name=?)";
        this.found = this.query(new QueryStatement<Set<Integer>>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, "Litebans");
                statement.setString(2, "bans");
                statement.setString(3, "warns");
                statement.setString(4, "kicks");
                statement.setString(5, "mutes");
            }

            @Override
            public Set<Integer> processResults(ResultSet set) throws SQLException {
                HashSet<Integer> ids = new HashSet<Integer>();
                while (set.next()) {
                    ids.add(set.getInt("id"));
                }
                return ids;
            }
        });
        return this.found.isEmpty();
    }

    @Override
    protected void applyPatch() {
        String sql = "DELETE FROM plan_extension_server_table_values WHERE table_id=?";
        this.execute(new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Integer id : LitebansTableHeaderPatch.this.found) {
                    statement.setInt(1, id);
                    statement.addBatch();
                }
            }
        });
    }
}

