/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.delivery.domain.Nickname;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.sql.building.Select;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import com.djrapitops.plan.utilities.java.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class NicknameLastSeenPatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn("plan_nicknames", "last_used");
    }

    @Override
    protected void applyPatch() {
        this.addColumn("plan_nicknames", "last_used bigint NOT NULL DEFAULT '0'");
        if (this.hasColumn("plan_nicknames", "uuid")) {
            return;
        }
        this.executeSwallowingExceptions("CREATE TABLE IF NOT EXISTS plan_actions (action_id integer, date bigint, server_id integer, user_id integer, additional_info varchar(1))");
        Map<Integer, UUID> serverUUIDsByID = this.getServerUUIDsByID();
        HashMap<UUID, Integer> serverIDsByUUID = new HashMap<UUID, Integer>();
        for (Map.Entry<Integer, UUID> entry : serverUUIDsByID.entrySet()) {
            serverIDsByUUID.put(entry.getValue(), entry.getKey());
        }
        Map<Integer, Set<Nickname>> nicknames = this.getNicknamesByUserID(serverUUIDsByID);
        this.updateLastUsed(serverIDsByUUID, nicknames);
        this.executeSwallowingExceptions("DROP TABLE plan_actions");
    }

    private Map<Integer, UUID> getServerUUIDsByID() {
        String sql = Select.from("plan_servers", "id", "uuid").toString();
        return this.query(new QueryAllStatement<Map<Integer, UUID>>(sql){

            @Override
            public Map<Integer, UUID> processResults(ResultSet set) throws SQLException {
                HashMap<Integer, UUID> uuids = new HashMap<Integer, UUID>();
                while (set.next()) {
                    int id = set.getInt("id");
                    uuids.put(id, UUID.fromString(set.getString("uuid")));
                }
                return uuids;
            }
        });
    }

    private Map<Integer, Set<Nickname>> getNicknamesByUserID(final Map<Integer, UUID> serverUUIDsByID) {
        String fetchSQL = "SELECT * FROM plan_actions WHERE action_id=3 ORDER BY date DESC";
        return this.query(new QueryAllStatement<Map<Integer, Set<Nickname>>>(fetchSQL, 10000){

            @Override
            public Map<Integer, Set<Nickname>> processResults(ResultSet set) throws SQLException {
                HashMap<Integer, Set<Nickname>> map = new HashMap<Integer, Set<Nickname>>();
                while (set.next()) {
                    long date = set.getLong("date");
                    int userID = set.getInt("user_id");
                    int serverID = set.getInt("server_id");
                    UUID serverUUID = (UUID)serverUUIDsByID.get(serverID);
                    Nickname nick = new Nickname(set.getString("additional_info"), date, serverUUID);
                    Set foundNicknames = map.computeIfAbsent(userID, Maps::createSet);
                    if (serverUUID == null || foundNicknames.contains(nick)) continue;
                    foundNicknames.add(nick);
                }
                return map;
            }
        });
    }

    private void updateLastUsed(final Map<UUID, Integer> serverIDsByUUID, final Map<Integer, Set<Nickname>> nicknames) {
        String updateSQL = "UPDATE plan_nicknames SET last_used=? WHERE nickname=? AND user_id=? AND server_id=?";
        this.execute(new ExecBatchStatement(updateSQL){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : nicknames.entrySet()) {
                    Integer userId = (Integer)entry.getKey();
                    Set nicks = (Set)entry.getValue();
                    for (Nickname nick : nicks) {
                        Integer serverID = (Integer)serverIDsByUUID.get(nick.getServerUUID());
                        statement.setLong(1, nick.getDate());
                        statement.setString(2, nick.getName());
                        statement.setInt(3, userId);
                        statement.setInt(4, serverID);
                        statement.addBatch();
                    }
                }
            }
        });
    }
}

