/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.queries.schema.H2SchemaQueries;
import com.djrapitops.plan.storage.database.queries.schema.MySQLSchemaQueries;
import com.djrapitops.plan.storage.database.queries.schema.SQLiteSchemaQueries;
import com.djrapitops.plan.storage.database.transactions.init.OperationCriticalTransaction;
import com.djrapitops.plugin.utilities.Verify;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public abstract class Patch
extends OperationCriticalTransaction {
    private static final String ALTER_TABLE = "ALTER TABLE ";

    public abstract boolean hasBeenApplied();

    protected abstract void applyPatch();

    @Override
    protected boolean shouldBeExecuted() {
        return !this.hasBeenApplied();
    }

    @Override
    protected void performOperations() {
        if (this.dbType == DBType.MYSQL) {
            this.disableForeignKeyChecks();
        }
        this.applyPatch();
        if (this.dbType == DBType.MYSQL) {
            this.enableForeignKeyChecks();
        }
    }

    private void enableForeignKeyChecks() {
        this.execute("SET FOREIGN_KEY_CHECKS=1");
    }

    private void disableForeignKeyChecks() {
        this.execute("SET FOREIGN_KEY_CHECKS=0");
    }

    protected boolean hasTable(String tableName) {
        switch (this.dbType) {
            case H2: {
                return this.query(H2SchemaQueries.doesTableExist(tableName));
            }
            case SQLITE: {
                return this.query(SQLiteSchemaQueries.doesTableExist(tableName));
            }
            case MYSQL: {
                return this.query(MySQLSchemaQueries.doesTableExist(tableName));
            }
        }
        throw new IllegalStateException("Unsupported Database Type: " + this.dbType.getName());
    }

    protected boolean hasColumn(String tableName, String columnName) {
        switch (this.dbType) {
            case H2: {
                return this.query(H2SchemaQueries.doesColumnExist(tableName, columnName));
            }
            case MYSQL: {
                return this.query(MySQLSchemaQueries.doesColumnExist(tableName, columnName));
            }
            case SQLITE: {
                return this.query(SQLiteSchemaQueries.doesColumnExist(tableName, columnName));
            }
        }
        throw new IllegalStateException("Unsupported Database Type: " + this.dbType.getName());
    }

    protected void addColumn(String tableName, String columnInfo) {
        this.execute(ALTER_TABLE + tableName + " ADD " + (this.dbType.supportsMySQLQueries() ? "" : "COLUMN ") + columnInfo);
    }

    protected void dropTable(String name) {
        this.execute("DROP TABLE IF EXISTS " + name);
    }

    protected void renameTable(String from, String to) {
        this.execute(this.getRenameTableSQL(from, to));
    }

    private String getRenameTableSQL(String from, String to) {
        switch (this.dbType) {
            case H2: 
            case SQLITE: {
                return ALTER_TABLE + from + " RENAME TO " + to;
            }
            case MYSQL: {
                return "RENAME TABLE " + from + " TO " + to;
            }
        }
        throw new IllegalArgumentException("DBType: " + this.dbType.getName() + " does not have rename table sql");
    }

    protected void dropForeignKeys(String referencedTable) {
        if (this.dbType != DBType.MYSQL) {
            return;
        }
        List<MySQLSchemaQueries.ForeignKeyConstraint> constraints = this.query(MySQLSchemaQueries.foreignKeyConstraintsOf(referencedTable));
        for (MySQLSchemaQueries.ForeignKeyConstraint constraint : constraints) {
            this.execute(ALTER_TABLE + constraint.getTable() + " DROP FOREIGN KEY " + constraint.getConstraintName());
        }
    }

    protected void ensureNoForeignKeyConstraints(String table) {
        if (this.dbType != DBType.MYSQL) {
            return;
        }
        List<MySQLSchemaQueries.ForeignKeyConstraint> constraints = this.query(MySQLSchemaQueries.foreignKeyConstraintsOf(table));
        Verify.isTrue(constraints.isEmpty(), () -> new DBOpException("Table '" + table + "' has constraints '" + constraints + "'"));
    }

    protected boolean allValuesHaveValueZero(String tableName, String column) {
        String sql = "SELECT * FROM " + tableName + " WHERE " + column + "=? LIMIT 1";
        return this.query(new QueryStatement<Boolean>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, 0);
            }

            @Override
            public Boolean processResults(ResultSet set) throws SQLException {
                return !set.next();
            }
        });
    }
}

