/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.PingTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class PingOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public PingOptimizationPatch() {
        this.tableName = "plan_ping";
        this.tempTableName = "temp_ping";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "uuid") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "user_id") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            this.tempOldTable();
            this.execute(PingTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "uuid" + ',' + "server_uuid" + ',' + "id" + ',' + "min_ping" + ',' + "max_ping" + ',' + "avg_ping" + ',' + "date" + ") SELECT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".user_id LIMIT 1), (SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "id" + ',' + "min_ping" + ',' + "max_ping" + ',' + "avg_ping" + ',' + "date" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(PingOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

