/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class RegisterDateMinimizationPatch
extends Patch {
    private Map<UUID, Long> registerDates;

    @Override
    public boolean hasBeenApplied() {
        this.registerDates = this.query(this.fetchSmallestServerRegisterDates());
        return this.registerDates.isEmpty();
    }

    private Query<Map<UUID, Long>> fetchSmallestServerRegisterDates() {
        String sql = "SELECT u1.uuid,u1.registered,min_registered FROM (SELECT uuid,MIN(registered) as min_registered FROM plan_user_info GROUP BY uuid) u2 JOIN plan_users u1 on u1.uuid=u2.uuid WHERE u1.registered>min_registered";
        return new QueryAllStatement<Map<UUID, Long>>(sql, 500){

            @Override
            public Map<UUID, Long> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, Long> dates = new HashMap<UUID, Long>();
                while (set.next()) {
                    UUID playerUUID = UUID.fromString(set.getString(1));
                    long newRegisterDate = set.getLong("min_registered");
                    dates.put(playerUUID, newRegisterDate);
                }
                return dates;
            }
        };
    }

    @Override
    protected void applyPatch() {
        if (this.registerDates.isEmpty()) {
            return;
        }
        String sql = "UPDATE plan_users SET registered=? WHERE uuid=? AND registered>?";
        this.execute(new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : RegisterDateMinimizationPatch.this.registerDates.entrySet()) {
                    UUID playerUUID = (UUID)entry.getKey();
                    Long registerDate = (Long)entry.getValue();
                    statement.setLong(1, registerDate);
                    statement.setString(2, playerUUID.toString());
                    statement.setLong(3, registerDate);
                    statement.addBatch();
                }
            }
        });
    }
}

