/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.SessionsTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class SessionsOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public SessionsOptimizationPatch() {
        this.tableName = "plan_sessions";
        this.tempTableName = "temp_sessions";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "uuid") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "user_id") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            this.dropForeignKeys(this.tableName);
            this.ensureNoForeignKeyConstraints(this.tableName);
            this.tempOldTable();
            this.execute(SessionsTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "uuid" + ',' + "server_uuid" + ',' + "id" + ',' + "session_start" + ',' + "session_end" + ',' + "mob_kills" + ',' + "deaths" + ',' + "afk_time" + ") SELECT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".user_id LIMIT 1), (SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "id" + ',' + "session_start" + ',' + "session_end" + ',' + "mob_kills" + ',' + "deaths" + ',' + "afk_time" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(SessionsOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

