/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.UserInfoTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class UserInfoOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public UserInfoOptimizationPatch() {
        this.tableName = "plan_user_info";
        this.tempTableName = "temp_user_info";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "uuid") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "user_id") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            this.tempOldTable();
            this.execute(UserInfoTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "uuid" + ',' + "server_uuid" + ',' + "registered" + ',' + "banned" + ',' + "opped" + ") SELECT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".user_id LIMIT 1), (SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "registered" + ',' + "banned" + ',' + "opped" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(UserInfoOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

