/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.sql.tables.GeoInfoTable;
import com.djrapitops.plan.storage.database.sql.tables.KillsTable;
import com.djrapitops.plan.storage.database.sql.tables.NicknamesTable;
import com.djrapitops.plan.storage.database.sql.tables.SessionsTable;
import com.djrapitops.plan.storage.database.sql.tables.TPSTable;
import com.djrapitops.plan.storage.database.sql.tables.UserInfoTable;
import com.djrapitops.plan.storage.database.sql.tables.UsersTable;
import com.djrapitops.plan.storage.database.sql.tables.WorldTable;
import com.djrapitops.plan.storage.database.sql.tables.WorldTimesTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import java.util.Optional;

public class Version10Patch
extends Patch {
    private Integer serverID;

    @Override
    public boolean hasBeenApplied() {
        return !this.hasTable("plan_gamemodetimes");
    }

    @Override
    protected void applyPatch() {
        Optional<Server> server = this.query(ServerQueries.fetchServerMatchingIdentifier(this.getServerUUID()));
        this.serverID = server.map(Server::getId).orElseThrow(() -> new IllegalStateException("Server UUID was not registered, try rebooting the plugin."));
        this.alterTablesToV10();
    }

    public void alterTablesToV10() {
        this.copyTPS();
        this.dropTable("plan_user_info");
        this.copyUsers();
        this.dropTable("plan_geolocations");
        this.execute(GeoInfoTable.createTableSQL(this.dbType));
        this.dropTable("plan_world_times");
        this.dropTable("plan_worlds");
        this.execute(WorldTable.createTableSQL(this.dbType));
        this.execute(WorldTimesTable.createTableSQL(this.dbType));
        this.dropTable("plan_gamemodetimes");
        this.dropTable("temp_nicks");
        this.dropTable("temp_kills");
        this.dropTable("temp_users");
    }

    private void copyUsers() {
        String tempTableName = "temp_users";
        this.renameTable("plan_users", tempTableName);
        String tempNickTableName = "temp_nicks";
        this.renameTable("plan_nicknames", tempNickTableName);
        String tempKillsTableName = "temp_kills";
        this.renameTable("plan_kills", tempKillsTableName);
        this.execute(UsersTable.createTableSQL(this.dbType));
        this.execute(NicknamesTable.createTableSQL(this.dbType));
        this.dropTable("plan_sessions");
        this.execute(SessionsTable.createTableSQL(this.dbType));
        this.execute(KillsTable.createTableSQL(this.dbType));
        this.execute(UserInfoTable.createTableSQL(this.dbType));
        String statement = "INSERT INTO plan_users (id, uuid, registered, name) SELECT id, uuid, registered, name FROM " + tempTableName;
        this.execute(statement);
        statement = "INSERT INTO plan_user_info (user_id, registered, opped, banned, server_id) SELECT id, registered, opped, banned, '" + this.serverID + "'" + " FROM " + tempTableName;
        this.execute(statement);
        statement = "INSERT INTO plan_nicknames (user_id, nickname, server_id) SELECT user_id, nickname, '" + this.serverID + "'" + " FROM " + tempNickTableName;
        this.execute(statement);
        statement = "INSERT INTO plan_kills (killer_id, victim_id, weapon, date, session_id) SELECT killer_id, victim_id, weapon, date, '0' FROM " + tempKillsTableName;
        this.execute(statement);
    }

    private void copyTPS() {
        String tempTableName = "temp_tps";
        this.renameTable("plan_tps", tempTableName);
        this.execute(TPSTable.createTableSQL(this.dbType));
        String statement = "INSERT INTO plan_tps (date, tps, players_online, cpu_usage, ram_usage, entities, chunks_loaded, server_id) SELECT date, tps, players_online, cpu_usage, ram_usage, entities, chunks_loaded, '" + this.serverID + "'" + " FROM " + tempTableName;
        this.execute(statement);
        this.dropTable(tempTableName);
    }
}

