/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.WorldTimesTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class WorldTimesOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public WorldTimesOptimizationPatch() {
        this.tableName = "plan_world_times";
        this.tempTableName = "temp_world_times";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "id") && this.hasColumn(this.tableName, "uuid") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "user_id") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            this.tempOldTable();
            this.execute(WorldTimesTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "uuid" + ',' + "server_uuid" + ',' + "adventure_time" + ',' + "creative_time" + ',' + "survival_time" + ',' + "spectator_time" + ',' + "session_id" + ',' + "world_id" + ") SELECT (SELECT plan_users.uuid FROM plan_users WHERE plan_users.id = " + this.tempTableName + ".user_id LIMIT 1), (SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "adventure_time" + ',' + "creative_time" + ',' + "survival_time" + ',' + "spectator_time" + ',' + "session_id" + ',' + "world_id" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(WorldTimesOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

