/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.sql.tables.WorldTable;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;

public class WorldsOptimizationPatch
extends Patch {
    private final String tempTableName;
    private final String tableName;

    public WorldsOptimizationPatch() {
        this.tableName = "plan_worlds";
        this.tempTableName = "temp_worlds";
    }

    @Override
    public boolean hasBeenApplied() {
        return this.hasColumn(this.tableName, "id") && this.hasColumn(this.tableName, "server_uuid") && !this.hasColumn(this.tableName, "server_id") && !this.hasTable(this.tempTableName);
    }

    @Override
    protected void applyPatch() {
        try {
            this.dropForeignKeys(this.tableName);
            this.ensureNoForeignKeyConstraints(this.tableName);
            this.tempOldTable();
            this.execute(WorldTable.createTableSQL(this.dbType));
            this.execute("INSERT INTO " + this.tableName + " (" + "id" + ',' + "server_uuid" + ',' + "world_name" + ") SELECT " + "id" + ',' + "(SELECT plan_servers.uuid FROM plan_servers WHERE plan_servers.id = " + this.tempTableName + ".server_id LIMIT 1), " + "world_name" + " FROM " + this.tempTableName);
            this.dropTable(this.tempTableName);
        }
        catch (Exception e) {
            throw new DBOpException(WorldsOptimizationPatch.class.getSimpleName() + " failed.", e);
        }
    }

    private void tempOldTable() {
        if (!this.hasTable(this.tempTableName)) {
            this.renameTable(this.tableName, this.tempTableName);
        }
    }
}

