/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database.transactions.patches;

import com.djrapitops.plan.storage.database.queries.LargeStoreQueries;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.patches.Patch;
import com.djrapitops.plan.storage.database.transactions.patches.WorldObj;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class WorldsServerIDPatch
extends Patch {
    @Override
    public boolean hasBeenApplied() {
        String tableName = "plan_worlds";
        String columnName = "server_id";
        return this.hasColumn(tableName, "server_uuid") || this.hasColumn(tableName, columnName) && this.allValuesHaveValueZero(tableName, columnName);
    }

    @Override
    protected void applyPatch() {
        Set<UUID> serverUUIDs = this.query(ServerQueries.fetchPlanServerInformation()).keySet();
        HashMap<UUID, Collection<String>> worldsPerServer = new HashMap<UUID, Collection<String>>();
        for (UUID serverUUID : serverUUIDs) {
            worldsPerServer.put(serverUUID, this.getWorldNamesOld(serverUUID));
        }
        this.execute(LargeStoreQueries.storeAllWorldNames(worldsPerServer));
        this.updateWorldTimesTableWorldIDs();
        this.executeSwallowingExceptions("DELETE FROM plan_worlds WHERE server_id=0");
    }

    private Set<String> getWorldNamesOld(final UUID serverUUID) {
        String worldIDColumn = "plan_world_times.world_id";
        String worldSessionIDColumn = "plan_world_times.session_id";
        String sessionIDColumn = "plan_sessions.id";
        String sessionServerUUIDColumn = "plan_sessions.server_uuid";
        String sql = "SELECT DISTINCT world_name FROM plan_worlds JOIN plan_world_times on " + worldIDColumn + "=" + "plan_worlds" + '.' + "id" + " JOIN " + "plan_sessions" + " on " + worldSessionIDColumn + "=" + sessionIDColumn + " WHERE " + sessionServerUUIDColumn + "=?";
        return this.query(new QueryStatement<Set<String>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public Set<String> processResults(ResultSet set) throws SQLException {
                HashSet<String> worldNames = new HashSet<String>();
                while (set.next()) {
                    worldNames.add(set.getString("world_name"));
                }
                return worldNames;
            }
        });
    }

    private void updateWorldTimesTableWorldIDs() {
        List<WorldObj> worldObjects = this.getWorldObjects();
        final Map oldToNewMap = worldObjects.stream().filter(worldObj -> worldObj.serverId == 0).collect(Collectors.toMap(Function.identity(), oldWorld -> worldObjects.stream().filter(worldObj -> worldObj.serverId != 0).filter(worldObj -> worldObj.equals(oldWorld)).collect(Collectors.toList())));
        String sql = "UPDATE plan_world_times SET world_id=? WHERE world_id=? AND server_id=?";
        this.execute(new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                for (Map.Entry entry : oldToNewMap.entrySet()) {
                    WorldObj old = (WorldObj)entry.getKey();
                    for (WorldObj newWorld : (List)entry.getValue()) {
                        statement.setInt(1, newWorld.id);
                        statement.setInt(2, old.id);
                        statement.setInt(3, newWorld.serverId);
                        statement.addBatch();
                    }
                }
            }
        });
    }

    public List<WorldObj> getWorldObjects() {
        String sql = "SELECT * FROM plan_worlds";
        return this.query(new QueryAllStatement<List<WorldObj>>(sql, 100){

            @Override
            public List<WorldObj> processResults(ResultSet set) throws SQLException {
                ArrayList<WorldObj> objects = new ArrayList<WorldObj>();
                while (set.next()) {
                    int worldID = set.getInt("id");
                    int serverID = set.getInt("server_id");
                    String worldName = set.getString("world_name");
                    objects.add(new WorldObj(worldID, serverID, worldName));
                }
                return objects;
            }
        });
    }
}

