/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.storage.file.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileResource
implements Resource {
    private final String resourceName;
    private final File file;

    public FileResource(String resourceName, File file) {
        this.resourceName = resourceName;
        this.file = file;
    }

    public static List<String> lines(File file) throws IOException {
        List<String> lines = new ArrayList<String>();
        if (file != null && file.exists()) {
            try (Stream<String> linesStream = Files.lines(file.toPath(), StandardCharsets.UTF_8);){
                lines = linesStream.collect(Collectors.toList());
            }
        }
        return lines;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public InputStream asInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return Files.readAllBytes(this.file.toPath());
    }

    @Override
    public List<String> asLines() throws IOException {
        return FileResource.lines(this.file);
    }

    @Override
    public String asString() throws IOException {
        StringBuilder flat = new StringBuilder();
        try (Scanner scanner = new Scanner(this.file, "UTF-8");){
            while (scanner.hasNextLine()) {
                flat.append(scanner.nextLine()).append("\r\n");
            }
        }
        return flat.toString();
    }
}

