/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.storage.file.FileResource;
import com.djrapitops.plan.storage.file.JarResource;
import com.djrapitops.plan.storage.file.Resource;
import com.djrapitops.plan.storage.file.ResourceCache;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlanFiles
implements SubSystem {
    protected final PlanPlugin plugin;
    private final File dataFolder;
    private final File configFile;

    @Inject
    public PlanFiles(PlanPlugin plugin) {
        this.dataFolder = plugin.getDataFolder();
        this.plugin = plugin;
        this.configFile = this.getFileFromPluginFolder("config.yml");
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public Path getDataDirectory() {
        return this.dataFolder.toPath();
    }

    public Path getCustomizationDirectory() {
        return this.getDataDirectory().resolve("web");
    }

    public File getLogsFolder() {
        try {
            File folder = this.getFileFromPluginFolder("logs");
            Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            return folder;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path getLogsDirectory() {
        return this.getDataDirectory().resolve("logs");
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public File getLocaleFile() {
        return this.getFileFromPluginFolder("locale.txt");
    }

    public File getFileFromPluginFolder(String name) {
        return new File(this.dataFolder, name.replace("/", File.separator));
    }

    @Override
    public void enable() throws EnableException {
        ResourceCache.invalidateAll();
        ResourceCache.cleanUp();
        Verify.isTrue(this.dataFolder.exists() && this.dataFolder.isDirectory() || this.dataFolder.mkdirs(), () -> new EnableException("Could not create data folder at " + this.dataFolder.getAbsolutePath()));
        try {
            Verify.isTrue(this.configFile.exists() && this.configFile.isFile() || this.configFile.createNewFile(), () -> new EnableException("Could not create config file at " + this.configFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new EnableException("Failed to create config.yml", e);
        }
    }

    @Override
    public void disable() {
    }

    public Resource getResourceFromJar(String resourceName) {
        return new JarResource("assets/plan/" + resourceName, () -> this.plugin.getResource("assets/plan/" + resourceName));
    }

    public Resource getResourceFromPluginFolder(String resourceName) {
        return new FileResource(resourceName, this.getFileFromPluginFolder(resourceName));
    }

    public Optional<Resource> getCustomizableResource(String resourceName) {
        return Optional.ofNullable(ResourceCache.getOrCache(resourceName, () -> this.attemptToFind(resourceName).map(found -> new FileResource(resourceName, (File)found)).orElse(null)));
    }

    private Optional<File> attemptToFind(String resourceName) {
        Path asPath;
        File found;
        Path dir = this.getCustomizationDirectory();
        if (dir.toFile().exists() && dir.toFile().isDirectory() && (found = (asPath = dir.resolve(resourceName)).toFile()).exists()) {
            return Optional.of(found);
        }
        return Optional.empty();
    }
}

