/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.delivery.web.resource.WebResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import plan.org.apache.commons.lang3.StringUtils;

public interface Resource {
    public String getResourceName();

    public byte[] asBytes() throws IOException;

    public InputStream asInputStream() throws IOException;

    public List<String> asLines() throws IOException;

    public String asString() throws IOException;

    default public WebResource asWebResource() {
        try {
            return WebResource.create(this.asInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read '" + this.getResourceName() + "'", e);
        }
    }

    public static boolean isTextResource(String resourceName) {
        return StringUtils.endsWithAny(resourceName, ".html", ".js", ".css", ".yml", ".txt");
    }
}

