/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.storage.file.Resource;
import com.djrapitops.plan.storage.file.StringCachingResource;
import com.djrapitops.plan.storage.file.StringResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;

public class ResourceCache {
    private static final Cache<String, String> cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private ResourceCache() {
    }

    public static Resource getOrCache(String resourceName, Supplier<Resource> resourceSupplier) {
        String found = cache.getIfPresent(resourceName);
        if (found == null) {
            Resource created = resourceSupplier.get();
            if (created == null) {
                return null;
            }
            return new StringCachingResource(created);
        }
        return new StringResource(resourceName, found);
    }

    public static void cache(String resourceName, String got) {
        cache.put(resourceName, got);
    }

    public static void invalidateAll() {
        cache.invalidateAll();
    }

    public static void cleanUp() {
        cache.cleanUp();
    }

    public static List<String> getCachedResourceNames() {
        ArrayList<String> resourceNames = new ArrayList<String>(cache.asMap().keySet());
        Collections.sort(resourceNames);
        return resourceNames;
    }
}

