/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.storage.file.Resource;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.spongepowered.api.asset.Asset;

public class SpongeAssetResource
implements Resource {
    private final String resourceName;
    private final Asset asset;

    public SpongeAssetResource(String resourceName, Asset asset) {
        this.resourceName = resourceName;
        this.asset = asset;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    private void nullCheck() throws FileNotFoundException {
        if (this.asset == null) {
            throw new FileNotFoundException("a Resource was not found inside the jar (/assets/plan/" + this.resourceName + "), Plan does not support /reload or updates using Plugin Managers, restart the server and see if the error persists.");
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        this.nullCheck();
        return new ByteArrayInputStream(this.asset.readBytes());
    }

    @Override
    public List<String> asLines() throws IOException {
        return this.asset.readLines(StandardCharsets.UTF_8);
    }

    @Override
    public String asString() throws IOException {
        return this.asset.readString(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.asset.readBytes();
    }
}

