/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.file;

import com.djrapitops.plan.storage.file.Resource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import plan.org.apache.commons.lang3.StringUtils;

public class StringResource
implements Resource {
    private final String resourceName;
    private final String resource;

    StringResource(String resourceName, String resource) {
        this.resourceName = resourceName;
        this.resource = resource;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.resource.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public List<String> asLines() {
        return Arrays.asList(StringUtils.split(this.resource, "\r\n"));
    }

    @Override
    public String asString() {
        return this.resource;
    }

    @Override
    public byte[] asBytes() {
        return this.resource.getBytes(StandardCharsets.UTF_8);
    }
}

