/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.upkeep;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.RemoveUnsatisfiedConditionalPlayerResultsTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.RemoveUnsatisfiedConditionalServerResultsTransaction;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.query.QuerySvc;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.transactions.commands.RemovePlayerTransaction;
import com.djrapitops.plan.storage.database.transactions.init.RemoveDuplicateUserInfoTransaction;
import com.djrapitops.plan.storage.database.transactions.init.RemoveOldExtensionsTransaction;
import com.djrapitops.plan.storage.database.transactions.init.RemoveOldSampledDataTransaction;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class DBCleanTask
extends AbsRunnable {
    private final Locale locale;
    private final DBSystem dbSystem;
    private final PlanConfig config;
    private final QuerySvc queryService;
    private final ServerInfo serverInfo;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final long lastReload;

    @Inject
    public DBCleanTask(PlanConfig config, Locale locale, DBSystem dbSystem, QuerySvc queryService, ServerInfo serverInfo, PluginLogger logger, ErrorLogger errorLogger) {
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.config = config;
        this.queryService = queryService;
        this.serverInfo = serverInfo;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.lastReload = System.currentTimeMillis();
    }

    @Override
    public void run() {
        Database database = this.dbSystem.getDatabase();
        try {
            if (database.getState() != Database.State.CLOSED) {
                database.executeTransaction(new RemoveOldSampledDataTransaction(this.serverInfo.getServerUUID(), this.config.get(TimeSettings.DELETE_TPS_DATA_AFTER), this.config.get(TimeSettings.DELETE_PING_DATA_AFTER)));
                database.executeTransaction(new RemoveDuplicateUserInfoTransaction());
                database.executeTransaction(new RemoveUnsatisfiedConditionalPlayerResultsTransaction());
                database.executeTransaction(new RemoveUnsatisfiedConditionalServerResultsTransaction());
                int removed = this.cleanOldPlayers(database);
                if (removed > 0) {
                    this.logger.info(this.locale.getString(PluginLang.DB_NOTIFY_CLEAN, Integer.valueOf(removed)));
                }
                Long deleteExtensionDataAfter = this.config.get(TimeSettings.DELETE_EXTENSION_DATA_AFTER);
                if (System.currentTimeMillis() - this.lastReload <= deleteExtensionDataAfter) {
                    database.executeTransaction(new RemoveOldExtensionsTransaction(deleteExtensionDataAfter, this.serverInfo.getServerUUID()));
                }
            }
        }
        catch (DBOpException e) {
            this.errorLogger.log(L.ERROR, e);
            this.cancel();
        }
    }

    public int cleanOldPlayers(Database database) {
        long now = System.currentTimeMillis();
        long keepActiveAfter = now - this.config.get(TimeSettings.DELETE_INACTIVE_PLAYERS_AFTER);
        List<UUID> inactivePlayers = database.query(this.fetchInactivePlayerUUIDs(keepActiveAfter));
        for (UUID playerUUID : inactivePlayers) {
            this.queryService.playerRemoved(playerUUID);
            database.executeTransaction(new RemovePlayerTransaction(playerUUID));
        }
        return inactivePlayers.size();
    }

    private Query<List<UUID>> fetchInactivePlayerUUIDs(final long keepActiveAfter) {
        String sql = "SELECT uuid, last_seen FROM (SELECT MAX(session_end) as last_seen, uuid FROM plan_sessions GROUP BY uuid) as q1 WHERE last_seen < ?";
        return new QueryStatement<List<UUID>>(sql, 20000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, keepActiveAfter);
            }

            @Override
            public List<UUID> processResults(ResultSet set) throws SQLException {
                ArrayList<UUID> inactiveUUIDs = new ArrayList<UUID>();
                while (set.next()) {
                    inactiveUUIDs.add(UUID.fromString(set.getString("uuid")));
                }
                return inactiveUUIDs;
            }
        };
    }
}

