/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.upkeep;

import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBKeepAliveTask
extends AbsRunnable {
    private final IReconnect iReconnect;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private Connection connection;

    public DBKeepAliveTask(Connection connection, IReconnect iReconnect, PluginLogger logger, ErrorLogger errorLogger) {
        this.connection = connection;
        this.iReconnect = iReconnect;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet resultSet;
        Statement statement;
        block6: {
            statement = null;
            resultSet = null;
            try {
                if (this.connection == null || this.connection.isClosed()) break block6;
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery("/* ping */ SELECT 1");
            }
            catch (SQLException pingException) {
                try {
                    this.logger.debug("Something went wrong during SQL Connection upkeep task.");
                    try {
                        this.connection = this.iReconnect.reconnect();
                    }
                    catch (SQLException reconnectionError) {
                        this.errorLogger.log(L.ERROR, reconnectionError, ErrorContext.builder().whatToDo("Reload Plan and Report this if the issue persists").build());
                        this.logger.error("SQL connection maintaining task had to be closed due to exception.");
                        this.cancel();
                    }
                }
                catch (Throwable throwable) {
                    MiscUtils.close(statement, resultSet);
                    throw throwable;
                }
                MiscUtils.close(statement, resultSet);
            }
        }
        MiscUtils.close(statement, resultSet);
    }

    public static interface IReconnect {
        public Connection reconnect() throws SQLException;
    }
}

