/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.upkeep;

import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class LogsFolderCleanTask
extends AbsRunnable {
    private final File folder;
    private final PlanConfig config;
    private final PluginLogger logger;

    @Inject
    public LogsFolderCleanTask(PlanFiles files, PlanConfig config, PluginLogger logger) {
        this.folder = files.getLogsFolder();
        this.config = config;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            if (!this.folder.exists() || this.folder.isFile()) {
                return;
            }
            this.cleanFolder();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            try {
                this.cancel();
            }
            catch (Exception exception) {}
        }
    }

    private void cleanFolder() {
        long now = System.currentTimeMillis();
        for (File file : Objects.requireNonNull(this.folder.listFiles())) {
            long forDaysMs = TimeUnit.DAYS.toMillis(this.config.get(PluginSettings.KEEP_LOGS_DAYS).intValue());
            if (now - file.lastModified() <= (forDaysMs > 0L ? forDaysMs : TimeUnit.DAYS.toMillis(1L))) continue;
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                this.logger.warn("Could not delete log file at: " + file.getAbsolutePath() + ", " + e.getMessage());
            }
        }
    }
}

