/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities;

import com.djrapitops.plan.settings.Permissions;
import com.djrapitops.plugin.command.CommandUtils;
import com.djrapitops.plugin.command.Sender;
import java.util.concurrent.TimeUnit;

public class MiscUtils {
    private MiscUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getPlayerName(String[] args, Sender sender) {
        return MiscUtils.getPlayerName(args, sender, Permissions.INSPECT_OTHER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPlayerName(String[] args, Sender sender, Permissions perm) {
        boolean isConsole;
        boolean bl = isConsole = !CommandUtils.isPlayer(sender);
        if (isConsole) {
            return args[0];
        }
        if (args.length <= 0) return sender.getName();
        if (sender.hasPermission(perm.getPermission())) {
            return args[0];
        }
        if (!args[0].equalsIgnoreCase(sender.getName())) return null;
        return sender.getName();
    }

    public static void close(AutoCloseable ... close) {
        for (AutoCloseable c : close) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static long dayAgo() {
        return MiscUtils.now() - TimeUnit.DAYS.toMillis(1L);
    }

    public static long weekAgo() {
        return MiscUtils.now() - TimeUnit.DAYS.toMillis(7L);
    }

    public static long monthAgo() {
        return MiscUtils.now() - TimeUnit.DAYS.toMillis(30L);
    }
}

