/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities;

import com.djrapitops.plan.exceptions.PassEncryptException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import plan.org.apache.commons.lang3.StringUtils;

public class PassEncryptUtil {
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int SALT_BYTE_SIZE = 24;
    private static final int HASH_BYTE_SIZE = 18;
    private static final int PBKDF2_ITERATIONS = 64000;
    private static final int HASH_SECTIONS = 5;
    private static final int HASH_ALGORITHM_INDEX = 0;
    private static final int ITERATION_INDEX = 1;
    private static final int HASH_SIZE_INDEX = 2;
    private static final int SALT_INDEX = 3;
    private static final int PBKDF2_INDEX = 4;

    private PassEncryptUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String createHash(String password) {
        return PassEncryptUtil.createHash(password.toCharArray());
    }

    private static String createHash(char[] password) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[24];
        random.nextBytes(salt);
        byte[] hash = PassEncryptUtil.pbkdf2(password, salt, 64000, 18);
        int hashSize = hash.length;
        return "sha1:64000:" + hashSize + ":" + PassEncryptUtil.toBase64(salt) + ":" + PassEncryptUtil.toBase64(hash);
    }

    public static boolean verifyPassword(String password, String correctHash) {
        return PassEncryptUtil.verifyPassword(password.toCharArray(), correctHash);
    }

    private static boolean verifyPassword(char[] password, String correctHash) {
        int storedHashSize;
        byte[] hash;
        byte[] salt;
        int iterations;
        String[] params = StringUtils.split(correctHash, ':');
        if (params.length != 5) {
            throw new InvalidHashException("Fields are missing from the password hash.");
        }
        if (!params[0].equals("sha1")) {
            throw new CannotPerformOperationException();
        }
        try {
            iterations = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidHashException("Could not parse the iteration count as an integer.", ex);
        }
        if (iterations < 1) {
            throw new InvalidHashException("Invalid number of iterations. Must be >= 1.");
        }
        try {
            salt = PassEncryptUtil.fromBase64(params[3]);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidHashException("Base64 decoding of salt failed.", ex);
        }
        try {
            hash = PassEncryptUtil.fromBase64(params[4]);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidHashException("Base64 decoding of pbkdf2 output failed.", ex);
        }
        try {
            storedHashSize = Integer.parseInt(params[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidHashException("Could not parse the hash size as an integer.", ex);
        }
        if (storedHashSize != hash.length) {
            throw new InvalidHashException("Hash length doesn't match stored hash length.");
        }
        byte[] testHash = PassEncryptUtil.pbkdf2(password, salt, iterations, hash.length);
        return PassEncryptUtil.slowEquals(hash, testHash);
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    private static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int bytes) {
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, bytes * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CannotPerformOperationException("Hash algorithm not supported: PBKDF2WithHmacSHA1", ex);
        }
        catch (InvalidKeySpecException ex) {
            throw new CannotPerformOperationException("Invalid key spec.", ex);
        }
    }

    private static byte[] fromBase64(String hex) {
        return Base64.getDecoder().decode(hex);
    }

    private static String toBase64(byte[] array) {
        return Base64.getEncoder().encodeToString(array);
    }

    public static class CannotPerformOperationException
    extends PassEncryptException {
        CannotPerformOperationException() {
            super("Unsupported hash type.");
        }

        CannotPerformOperationException(String message, Throwable source) {
            super(message, source);
        }
    }

    public static class InvalidHashException
    extends PassEncryptException {
        InvalidHashException(String message) {
            super(message);
        }

        InvalidHashException(String message, Throwable source) {
            super(message, source);
        }
    }
}

