/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.analysis;

import java.util.Collections;
import java.util.List;

public class Median<T extends Number> {
    private final List<T> values;
    private final int size;

    private Median(List<T> values) {
        this.values = values;
        Collections.sort(values);
        this.size = values.size();
    }

    public static <T extends Number> Median<T> forList(List<T> list) {
        return new Median<T>(list);
    }

    public double calculate() {
        if (this.values.isEmpty()) {
            return -1.0;
        }
        if (this.size % 2 == 0) {
            return this.calculateEven();
        }
        return this.calculateOdd();
    }

    private double calculateEven() {
        int half = this.size / 2;
        double x1 = ((Number)this.values.get(half)).doubleValue();
        double x2 = ((Number)this.values.get(half - 1)).doubleValue();
        return (x1 + x2) / 2.0;
    }

    private double calculateOdd() {
        int half = this.size / 2;
        return ((Number)this.values.get(half)).doubleValue();
    }
}

