/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.analysis;

import java.util.concurrent.TimeUnit;

public class TimerAverage {
    private long savePeriodMs;
    private long lastSaveMs;
    private double total;
    private int count;

    public TimerAverage() {
        this(TimeUnit.MINUTES.toMillis(1L));
    }

    public TimerAverage(long savePeriodMs) {
        this.savePeriodMs = savePeriodMs;
        this.lastSaveMs = 0L;
        this.total = 0.0;
        this.count = 0;
    }

    public boolean add(long time, double value) {
        if (this.lastSaveMs <= 0L) {
            this.lastSaveMs = time;
        }
        if (value < 0.0) {
            return false;
        }
        this.total += value;
        ++this.count;
        return time - this.lastSaveMs >= this.savePeriodMs;
    }

    public double getAverageAndReset(long time) {
        this.lastSaveMs = time;
        double average = this.total / (double)this.count;
        this.total = 0.0;
        this.count = 0;
        return average;
    }
}

