/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class Lists {
    private Lists() {
    }

    public static <V, K> List<V> create(K key) {
        return new ArrayList();
    }

    public static <V> Builder<V> builder(Class<V> ofType) {
        return new Builder();
    }

    public static <T extends V, V> List<T> filter(Collection<T> original, Predicate<V> keep) {
        ArrayList<T> filtered = new ArrayList<T>();
        for (T value : original) {
            if (!keep.test(value)) continue;
            filtered.add(value);
        }
        return filtered;
    }

    public static <A, B> List<B> map(Collection<A> original, Function<A, B> mapper) {
        ArrayList<B> mapped = new ArrayList<B>();
        for (A element : original) {
            mapped.add(mapper.apply(element));
        }
        return mapped;
    }

    public static <A, B> Set<B> mapUnique(Collection<A> original, Function<A, B> mapper) {
        HashSet<B> mapped = new HashSet<B>();
        for (A element : original) {
            mapped.add(mapper.apply(element));
        }
        return mapped;
    }

    public static class Builder<V> {
        private final List<V> list = new ArrayList<V>();

        private Builder() {
        }

        public Builder<V> add(V value) {
            this.list.add(value);
            return this;
        }

        public Builder<V> addAll(Collection<V> values) {
            this.list.addAll(values);
            return this;
        }

        public Builder<V> apply(UnaryOperator<Builder<V>> operator) {
            return (Builder)operator.apply(this);
        }

        public List<V> build() {
            return this.list;
        }
    }
}

