/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public final class Reflection {
    private static final String OBC_PREFIX = Reflection.getOBCPrefix();
    private static final String NMS_PREFIX = OBC_PREFIX.replace("org.bukkit.craftbukkit", "net.minecraft.server");

    private Reflection() {
    }

    private static String getOBCPrefix() {
        Server server = Bukkit.getServer();
        return server != null ? server.getClass().getPackage().getName() : Server.class.getPackage().getName();
    }

    public static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType) {
        return Reflection.getField(target, name, fieldType, 0);
    }

    private static <T> FieldAccessor<T> getField(Class<?> target, String name, Class<T> fieldType, int index) {
        for (final Field field : target.getDeclaredFields()) {
            if (name != null && !field.getName().equals(name) || !fieldType.isAssignableFrom(field.getType()) || index-- > 0) continue;
            field.setAccessible(true);
            return new FieldAccessor<T>(){

                @Override
                public T get(Object target) {
                    try {
                        return field.get(target);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot access reflection.", e);
                    }
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Cannot access reflection.", e);
                    }
                }

                @Override
                public boolean hasField(Object target) {
                    return field.getDeclaringClass().isAssignableFrom(target.getClass());
                }
            };
        }
        if (target.getSuperclass() != null) {
            return Reflection.getField(target.getSuperclass(), name, fieldType, index);
        }
        throw new IllegalArgumentException("Cannot find field with type " + fieldType);
    }

    public static MethodInvoker getMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        return Reflection.getTypedMethod(clazz, methodName, null, params);
    }

    public static MethodInvoker getTypedMethod(Class<?> clazz, String methodName, Class<?> returnType, Class<?> ... params) {
        for (Method method : clazz.getDeclaredMethods()) {
            if ((methodName != null && !method.getName().equals(methodName) || returnType != null) && (!method.getReturnType().equals(returnType) || !Arrays.equals(method.getParameterTypes(), params))) continue;
            method.setAccessible(true);
            return (target, arguments) -> {
                try {
                    return method.invoke(target, arguments);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot invoke method " + method, e);
                }
            };
        }
        if (clazz.getSuperclass() != null) {
            return Reflection.getMethod(clazz.getSuperclass(), methodName, params);
        }
        throw new IllegalStateException(String.format("Unable to find method %s (%s).", methodName, Arrays.asList(params)));
    }

    public static Class<?> getMinecraftClass(String name) {
        return Reflection.getCanonicalClass(NMS_PREFIX + '.' + name);
    }

    public static Class<?> getCraftBukkitClass(String name) {
        return Reflection.getCanonicalClass(OBC_PREFIX + '.' + name);
    }

    private static Class<?> getCanonicalClass(String canonicalName) {
        try {
            return Class.forName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find " + canonicalName, e);
        }
    }

    public static interface FieldAccessor<T> {
        public T get(Object var1);

        public void set(Object var1, Object var2);

        public boolean hasField(Object var1);
    }

    @FunctionalInterface
    public static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2);
    }
}

