/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ErrorContext {
    private final List<Object> related = new ArrayList<Object>();
    private String whatToDo;

    private ErrorContext() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getWhatToDo() {
        return Optional.ofNullable(this.whatToDo);
    }

    public Collection<String> toLines() {
        ArrayList<String> lines = new ArrayList<String>();
        this.getWhatToDo().ifPresent(lines::add);
        for (Object o : this.related) {
            lines.add(Objects.toString(o));
        }
        return lines;
    }

    public void merge(ErrorContext context) {
        this.related.addAll(context.related);
    }

    public static class Builder {
        private final ErrorContext context = new ErrorContext();

        public Builder whatToDo(String whatToDo) {
            this.context.whatToDo = whatToDo;
            return this;
        }

        public Builder related(Object related) {
            this.context.related.add(related);
            return this;
        }

        public Builder related(Object ... related) {
            this.context.related.addAll(Arrays.asList(related));
            return this;
        }

        public ErrorContext build() {
            return this.context;
        }
    }
}

