/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.utilities.logging;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.exceptions.ExceptionWithContext;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.error.ErrorHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.codec.digest.DigestUtils;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class ErrorLogger
implements ErrorHandler {
    private final PlanPlugin plugin;
    private final PluginLogger logger;
    private final PlanFiles files;
    private final Lazy<ServerProperties> serverProperties;
    private final Lazy<VersionChecker> versionChecker;
    private final Lazy<Formatters> formatters;

    @Inject
    public ErrorLogger(PlanPlugin plugin, PluginLogger logger, PlanFiles files, Lazy<ServerProperties> serverProperties, Lazy<VersionChecker> versionChecker, Lazy<Formatters> formatters) {
        this.plugin = plugin;
        this.logger = logger;
        this.files = files;
        this.serverProperties = serverProperties;
        this.versionChecker = versionChecker;
        this.formatters = formatters;
    }

    public <T extends ExceptionWithContext> void log(L level, T throwable) {
        this.log(level, (Throwable)((Object)throwable), throwable.getContext().orElse(ErrorContext.builder().related((Object)"Missing Context").build()));
    }

    public void log(L level, Throwable throwable, ErrorContext context) {
        String errorName = throwable.getClass().getSimpleName();
        String hash = this.hash(throwable);
        Path logsDir = this.files.getLogsDirectory();
        Path errorLog = logsDir.resolve(errorName + "-" + hash + ".txt");
        this.mergeAdditionalContext(throwable, context);
        if (Files.exists(errorLog, new LinkOption[0])) {
            this.logExisting(errorLog, throwable, context, hash);
        } else {
            this.logNew(errorLog, throwable, context, hash);
        }
        this.logToConsole(level, errorLog, throwable, context);
        if (L.CRITICAL == level) {
            this.plugin.getPluginLogger().error("CRITICAL error triggered a plugin shutdown.");
            this.plugin.onDisable();
        }
    }

    public void mergeAdditionalContext(Throwable throwable, ErrorContext context) {
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ExceptionWithContext)) continue;
            ((ExceptionWithContext)((Object)cause)).getContext().ifPresent(context::merge);
        }
    }

    private void logExisting(Path errorLog, Throwable throwable, ErrorContext context, String hash) {
        List<String> lines;
        try (Stream<String> read = Files.lines(errorLog);){
            lines = read.collect(Collectors.toList());
        }
        catch (IOException e) {
            this.logAfterReadError(errorLog, throwable, context, hash);
            return;
        }
        int occurrences = this.getOccurrences(lines) + 1;
        List<String> newLines = this.buildNewLines(context, lines, occurrences, hash);
        this.overwrite(errorLog, throwable, newLines);
    }

    private void overwrite(Path errorLog, Throwable throwable, List<String> newLines) {
        try {
            Files.write(errorLog, newLines, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throwable.addSuppressed(e);
            Logger.getGlobal().log(Level.SEVERE, "Failed to log Plan error, see suppressed.", throwable);
        }
    }

    private List<String> buildNewLines(ErrorContext context, List<String> lines, int occurrences, String hash) {
        Lists.Builder<String> builder = Lists.builder(String.class).add(hash + " - Last occurred: " + this.getTimeStamp() + " Occurrences: " + occurrences);
        if (occurrences <= 5) {
            builder = this.buildContext(context, occurrences, builder);
        }
        int lineCount = lines.size();
        int firstContextLineIndex = this.findFirstContextLine(lines, lineCount);
        return builder.addAll(lines.subList(firstContextLineIndex, lineCount)).build();
    }

    private String getTimeStamp() {
        return (String)this.formatters.get().iso8601NoClockLong().apply(System.currentTimeMillis());
    }

    private Lists.Builder<String> buildContext(ErrorContext context, int occurrences, Lists.Builder<String> builder) {
        return builder.add("---- Context " + occurrences + " ----").add("Plan v" + this.versionChecker.get().getCurrentVersion()).add(this.serverProperties.get().getName() + " " + this.serverProperties.get().getVersion()).add("Server v" + this.serverProperties.get().getImplVersion()).add("").addAll(context.toLines()).add("");
    }

    private void logAfterReadError(Path errorLog, Throwable throwable, ErrorContext context, String hash) {
        this.logger.error("Failed to read " + errorLog + " deleting file");
        try {
            Files.deleteIfExists(errorLog);
        }
        catch (IOException ioException) {
            this.logger.error("Failed to delete " + errorLog);
        }
        this.logNew(errorLog, throwable, context, hash);
    }

    private int getOccurrences(List<String> lines) {
        String occurLine = lines.get(0);
        return Integer.parseInt(StringUtils.splitByWholeSeparator(occurLine, ": ")[2].trim());
    }

    private int findFirstContextLine(List<String> lines, int lineCount) {
        int firstContextLineIndex = 0;
        for (int i = 0; i < lineCount; ++i) {
            if (!lines.get(i).contains("---- Context")) continue;
            firstContextLineIndex = i;
            break;
        }
        return firstContextLineIndex;
    }

    private void logToConsole(L level, Path errorLog, Throwable throwable, ErrorContext context) {
        String errorName = throwable.getClass().getSimpleName();
        String errorMsg = throwable.getMessage();
        String errorLocation = errorLog.toString();
        this.logger.log(level, "Ran into " + errorName + " - logged to " + errorLocation, "(INCLUDE CONTENTS OF THE FILE IN ANY REPORTS)", context.getWhatToDo().map(td -> "What to do: " + td).orElse("Error msg: \"" + errorMsg + "\""));
    }

    private void logNew(Path errorLog, Throwable throwable, ErrorContext context, String hash) {
        List<String> stacktrace = this.buildReadableStacktrace(new ArrayList<String>(), throwable);
        List<String> lines = Lists.builder(String.class).add(hash + " - Last occurred: " + this.getTimeStamp() + " Occurrences: 1").apply(builder -> this.buildContext(context, 1, (Lists.Builder<String>)builder)).add("---- Stacktrace ----").addAll(stacktrace).build();
        this.writeNew(errorLog, throwable, lines);
    }

    private void writeNew(Path errorLog, Throwable throwable, List<String> lines) {
        try {
            Files.createDirectories(errorLog.getParent(), new FileAttribute[0]);
            Files.write(errorLog, lines, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throwable.addSuppressed(e);
            Logger.getGlobal().log(Level.SEVERE, "Failed to log Plan error, see suppressed.", throwable);
        }
    }

    @Override
    @Deprecated
    public void log(L level, Class caughtBy, Throwable throwable) {
        this.log(level, throwable, ErrorContext.builder().related((Object)("Caught by " + caughtBy.getName())).build());
    }

    private String hash(Throwable e) {
        int seed = 0;
        String previousLine = null;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            for (StackTraceElement element : cause.getStackTrace()) {
                String asLine = element.toString();
                if (asLine.equals(previousLine)) continue;
                seed = seed == 0 ? asLine.hashCode() : (seed *= asLine.hashCode());
                previousLine = asLine;
            }
        }
        return DigestUtils.sha256Hex(Integer.toString(seed)).substring(0, 10);
    }

    private List<String> buildReadableStacktrace(List<String> trace, Throwable e) {
        Throwable cause;
        trace.add(e.toString());
        Deduplicator deduplicator = new Deduplicator();
        for (StackTraceElement element : e.getStackTrace()) {
            String line = element.toString();
            deduplicator.addLines(trace, line);
        }
        deduplicator.addLeftoverDuplicateCountLine(trace);
        Throwable[] suppressed = e.getSuppressed();
        if (suppressed.length > 0) {
            for (Throwable suppressedThrowable : suppressed) {
                trace.add("   Suppressed:");
                for (String line : this.buildReadableStacktrace(new ArrayList<String>(), suppressedThrowable)) {
                    trace.add("   " + line);
                }
            }
        }
        if ((cause = e.getCause()) != null) {
            trace.add("Caused by:");
            this.buildReadableStacktrace(trace, cause);
        }
        return trace;
    }

    private static class Deduplicator {
        private String previousLine = null;
        private String lastDuplicate = null;
        private int duplicateCount = 0;

        private Deduplicator() {
        }

        public void addLines(List<String> trace, String line) {
            if (this.duplicateCount > 0 && !line.equals(this.lastDuplicate)) {
                String returnLine = "    x " + this.duplicateCount;
                this.duplicateCount = 1;
                trace.add(returnLine);
                trace.add("   " + line);
            } else if (line.equals(this.lastDuplicate)) {
                ++this.duplicateCount;
            } else if (line.equals(this.previousLine)) {
                this.lastDuplicate = line;
                this.duplicateCount = 2;
            } else {
                this.previousLine = line;
                trace.add("   " + line);
            }
        }

        public void addLeftoverDuplicateCountLine(List<String> trace) {
            if (this.duplicateCount > 0) {
                trace.add("    x " + this.duplicateCount);
            }
        }
    }
}

