/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.version;

import com.djrapitops.plan.PlanPlugin;
import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plan.version.VersionInfo;
import com.djrapitops.plan.version.VersionInfoLoader;
import com.djrapitops.plugin.api.utility.Version;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Named;
import plan.javax.inject.Singleton;

@Singleton
public class VersionChecker
implements SubSystem {
    private final String currentVersion;
    private final Locale locale;
    private final PlanConfig config;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final PlanPlugin plugin;
    private VersionInfo newVersionAvailable;

    @Inject
    public VersionChecker(@Named(value="currentVersion") String currentVersion, Locale locale, PlanConfig config, PluginLogger logger, ErrorLogger errorLogger, PlanPlugin plugin) {
        this.currentVersion = currentVersion;
        this.locale = locale;
        this.config = config;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.plugin = plugin;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersionAvailable != null;
    }

    private void checkForUpdates() {
        try {
            VersionInfo newestVersion;
            List<VersionInfo> versions = VersionInfoLoader.load();
            if (this.config.isFalse(PluginSettings.NOTIFY_ABOUT_DEV_RELEASES)) {
                versions = Lists.filter(versions, VersionInfo::isRelease);
            }
            if (Version.isNewVersionAvailable(new Version(this.currentVersion), (newestVersion = versions.get(0)).getVersion())) {
                this.newVersionAvailable = newestVersion;
                String notification = this.locale.getString(PluginLang.VERSION_AVAILABLE, new Serializable[]{newestVersion.getVersion().toString(), newestVersion.getChangeLogUrl()}) + (newestVersion.isRelease() ? "" : this.locale.getString(PluginLang.VERSION_AVAILABLE_DEV));
                this.logger.log(L.INFO_COLOR, "\u00a7a----------------------------------------");
                this.logger.log(L.INFO_COLOR, "\u00a7a" + notification);
                this.logger.log(L.INFO_COLOR, "\u00a7a----------------------------------------");
            } else {
                this.logger.info(this.locale.getString(PluginLang.VERSION_NEWEST));
            }
        }
        catch (IOException e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)this.locale.getString(PluginLang.VERSION_FAIL_READ_VERSIONS)).whatToDo("Allow Plan to check for updates from Github/versions.txt or disable update check.").build());
        }
    }

    @Override
    public void enable() {
        if (this.config.isFalse(PluginSettings.CHECK_FOR_UPDATES)) {
            return;
        }
        this.plugin.getRunnableFactory().create("VersionChecker", new AbsRunnable(){

            @Override
            public void run() {
                VersionChecker.this.checkForUpdates();
            }
        }).runTaskAsynchronously();
    }

    @Override
    public void disable() {
    }

    public Optional<VersionInfo> getNewVersionAvailable() {
        return Optional.ofNullable(this.newVersionAvailable);
    }

    public Optional<String> getUpdateButton() {
        return this.getNewVersionAvailable().map(v -> "<button class=\"btn bg-white col-plan\" data-target=\"#updateModal\" data-toggle=\"modal\" type=\"button\"><i class=\"fa fa-fw fa-download\"></i> v." + v.getVersion().getVersionString() + "</button>");
    }

    public String getCurrentVersionButton() {
        return "<button class=\"btn bg-plan\" data-target=\"#updateModal\" data-toggle=\"modal\" type=\"button\">v." + this.getCurrentVersion() + "</button>";
    }

    public String getUpdateModal() {
        return this.getNewVersionAvailable().map(v -> "<div class=\"modal-header\"><h5 class=\"modal-title\" id=\"updateModalLabel\"><i class=\"fa fa-fw fa-download\"></i> Version " + v.getVersion().getVersionString() + " is Available!</h5><button aria-label=\"Close\" class=\"close\" data-dismiss=\"modal\" type=\"button\"><span aria-hidden=\"true\">&times;</span></button></div><div class=\"modal-body\"><p>A new version has been released and is now available for download." + (v.isRelease() ? "" : "<br>This version is a DEV release.") + "</p><a class=\"btn col-plan\" href=\"" + v.getChangeLogUrl() + "\" rel=\"noopener noreferrer\" target=\"_blank\"><i class=\"fa fa-fw fa-list\"></i> View Changelog</a><a class=\"btn col-plan\" href=\"" + v.getDownloadUrl() + "\" rel=\"noopener noreferrer\" target=\"_blank\"><i class=\"fa fa-fw fa-download\"></i> Download Plan-" + v.getVersion().getVersionString() + ".jar</a></div>").orElse("<div class=\"modal-header\"><h5 class=\"modal-title\" id=\"updateModalLabel\"><i class=\"far fa-fw fa-check-circle\"></i> You have version " + this.getCurrentVersion() + "</h5><button aria-label=\"Close\" class=\"close\" data-dismiss=\"modal\" type=\"button\"><span aria-hidden=\"true\">&times;</span></button></div><div class=\"modal-body\"><p>You are running the latest version.</p></div>");
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

