/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.version;

import com.djrapitops.plan.version.VersionInfo;
import com.djrapitops.plugin.api.utility.Version;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import plan.org.apache.commons.lang3.StringUtils;

public class VersionInfoLoader {
    private static final String VERSION_TXT_URL = "https://raw.githubusercontent.com/Rsl1122/Plan-PlayerAnalytics/master/versions.txt";

    private VersionInfoLoader() {
    }

    public static List<VersionInfo> load() throws IOException {
        URL url = new URL(VERSION_TXT_URL);
        ArrayList<VersionInfo> versionInfo = new ArrayList<VersionInfo>();
        try (Scanner websiteScanner = new Scanner(url.openStream());){
            while (websiteScanner.hasNextLine()) {
                VersionInfoLoader.checkLine(websiteScanner).ifPresent(lineParts -> {
                    boolean release = lineParts[0].equals("REL");
                    Version version = new Version(lineParts[1]);
                    String downloadUrl = lineParts[2];
                    String changeLogUrl = lineParts[3];
                    versionInfo.add(new VersionInfo(release, version, downloadUrl, changeLogUrl));
                });
            }
        }
        Collections.sort(versionInfo);
        return versionInfo;
    }

    private static Optional<String[]> checkLine(Scanner websiteScanner) {
        String line = websiteScanner.nextLine();
        if (!line.startsWith("REL") && !line.startsWith("DEV")) {
            return Optional.empty();
        }
        String[] parts = StringUtils.split(line, '|');
        if (parts.length < 4) {
            return Optional.empty();
        }
        return Optional.of(parts);
    }
}

